#This script computes the ash dieback spread from 2008 to 2100 on the FFSM grid.
#
#The inputs are: 1) the grid (pxIds.grd); 2) The asympthotic speed is set to 50000 m/year (parameter "c").
#3) The entry points (file entry_points) as observed ones from the Forest Health Department in France (DSF)
#
#The program generates for each year (cs[year].asc) a raster with 0 if the cell is not invaded and 1 if the cell is invaded


rm(list = ls())


# spatial
library(raster)
library(rgdal)
library(sp)
library(rasterVis)

#grid id repository
grid_dir<-c("~/LEF/Dottorato/Case_studies/Chalara/Data/Ash_distribution/FFSM_input/Kriging/Results/Output_ordkrig/")

#entry point repository
entrp_dir<-c("C:/Users/Claudio PETUCCO/Documents/LEF/Dottorato/Case_studies/Chalara/Data/Chalara Spread France")

#output repository
output_dir<-c("~/LEF/Dottorato/Case_studies/Chalara/Data/Chalara Spread France/Spread/")

#Entry points
entryp<- readOGR(entrp_dir, "entry_points")


#spread speed
c<-50000

# loading raster map
grid<-raster(paste0(grid_dir,"pxIds.grd"))
projection(grid)<- CRS("+init=epsg:3035")

#2006 2007 No pathogen
cs2006<-grid-grid



entryp$ep08<-0
entryp$ep08[which(entryp$ANNEE==2008)]<-1

cs2008<-rasterize(entryp,grid,'ep08', fun='max')

writeRaster(cs2008, filename=paste0(output_dir,"cs2008.asc"), format="ascii",datatype="INT2U", overwrite=TRUE)


#loop 2009-2010
for(i in 2009:2010) 
{
  myfile <- file.path(output_dir, paste0("cs", i-1, ".asc"))
  invd<-raster(myfile)
  invd[invd==0]<--NA
  d<-distance(invd)
  newinv<-grid
  newinv[d < c]<-1
  newinv[d>= c]<-0
  newinv<-mask(newinv, grid)
  
  
  writeRaster(newinv, filename=file.path(output_dir, paste0("cs", i, ".asc")),format="ascii",datatype="INT2U", overwrite=TRUE)
}

# new entry points 2010

entryp$ep10<-0
entryp$ep10[which(entryp$ANNEE==2010)]<-1

cs2010obs<-rasterize(entryp,grid,'ep10', fun='max')
cs2010<-raster(paste0(output_dir,"cs2010.asc"))
cs2010obs[25:147,]<-0
cs2010[cs2010obs==1]<-1

#plot jpg
jpeg(file=paste0(output_dir,"cs2010.jpg"))
plot(cs2010, main = "cs2010")
dev.off()

writeRaster(cs2010, filename=paste0(output_dir,"cs2010.asc"), format="ascii",datatype="INT2U", overwrite=TRUE)

#loop 2011-2100
for(i in 2011:2100) 
{
  myfile <- file.path(output_dir, paste0("cs", i-1, ".asc"))
  invd<-raster(myfile)
  invd[invd==0]<--NA
  d<-distance(invd)
  newinv<-grid
  newinv[d < c]<-1
  newinv[d >= c]<-0
  newinv<-mask(newinv, grid)
  

  writeRaster(newinv, filename=file.path(output_dir, paste0("cs", i, ".asc")),
              format="ascii", datatype="INT2U", overwrite=TRUE)
}